<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?= strip_tags($soft_name) ?></title>

    <!-- Bootstrap 4.6 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="/user-assets/css/user.css">
    
</head>
<body>
<!-- LOADER -->
<div class="loader-overlay">
    <div class="rotating-loader"></div>
</div>

<!-- NAVBAR LIGHT -->
<nav class="navbar navbar-expand-lg navbar-light bg-light fixed-top border-bottom">
    <button class="btn btn-outline-secondary mr-3" type="button" id="sidebarCollapse">
        <i class="fas fa-bars"></i>
    </button>

    <a class="navbar-brand" href="#">
        <img src="/user-assets/img/tech-fuse-logo-inner.png" alt="Logo" style="height:35px;">
        
    </a>
</nav>

<div class="wrapper d-flex">

    <!-- SIDEBAR -->
<nav id="sidebar" class="bg-light border-right">
    <div class="sidebar-header d-flex justify-content-between align-items-center px-3 py-2 border-bottom">
        <small class="text-uppercase"><?=$soft_name ?> MENU</small>
        <button type="button" id="sidebarClose" class="btn btn-sm btn-light">
            <i class="fas fa-times"></i>
        </button>
    </div>

    <!-- Logo Centered -->
    <div class="sidebar-logo text-center my-3">
        <img src="/user-assets/img/tech-fuse-logo-inner.png" alt="Logo" class="img-fluid" style="height:25px;">
    </div>

    <ul class="list-unstyled components mt-2">
        <li>
            <a href="<?= user_home ?>" class="nav-link">
                <i class="fas fa-home mr-2"></i> Accueil / Dashboard
            </a>
        </li>

        <li>
            <a href="<?= user_listing ?>" class="nav-link">
                <i class="fas fa-folder-open mr-2"></i> Mes dossiers
            </a>
        </li>

        <li>
            <a href="<?= user_login_authoriser ?>?logout=true" class="nav-link">
                <i class="fas fa-sign-out-alt mr-2"></i> Déconnexion
            </a>
        </li>
    </ul>
</nav>


<!-- Overlay -->
<div class="overlay"></div>


    <!-- OVERLAY -->
     <div class="overlay"> </div>


