<?php
include __DIR__ . '/user-ssinclude/user-init.php';
?>
<!doctype html>
<html lang="fr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login | <?php echo strip_tags($soft_name); ?> <?php echo $soft_info; ?></title>

<!-- Bootstrap -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

<!-- Lobibox -->
<link href="https://cdn.jsdelivr.net/npm/lobibox@1.2.7/dist/css/lobibox.min.css" rel="stylesheet">

<!-- Custom CSS -->
<link rel="stylesheet" href="user-assets/css/user.css">

<style>
/* ----------------------------- */
/* GLOBAL LAYOUT */
/* ----------------------------- */
body {
    margin: 0;
    padding: 0;
    min-height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
}

/* ----------------------------- */
/* LOGIN CONTAINER */
/* ----------------------------- */
.login-form {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    max-width: 450px;
    width: 100%;
    padding: 20px;
    background: #ffffff;
}

/* ----------------------------- */
/* LOADER */
/* ----------------------------- */
.loader-overlay {
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background: rgba(255,255,255,0.85);
    backdrop-filter: blur(3px);
    display: none;
    justify-content: center;
    align-items: center;
    z-index: 99999;
}

.rotating-loader {
    width: 60px;
    height: 60px;
    border: 6px solid #ddd;
    border-top-color: #28a745;
    border-radius: 50%;
    animation: spin 0.9s linear infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}
</style>
</head>
<body>

<?php if (verif_get('err')=="failed") { ?>
    <notify class="notify-alert">Connexion refusée. <br> PIN incorrect.</notify>
<?php } ?>

<!-- LOADER -->
<div class="loader-overlay">
    <div class="rotating-loader"></div>
</div>

<!-- FORMULAIRE -->
<div class="login-form text-center">
    <img src="user-assets/img/tech-fuse-logo.png" class="logo mb-3"/>
    <h4><?php echo $soft_name ?></h4>

    <form id="loginForm" method="POST" action="<?php echo user_login_authoriser ?>" autocomplete="off">
        <p>Saisissez votre code PIN à 8 chiffres :</p>

        <div class="pin-inputs">
            <?php for($i=0;$i<8;$i++): ?>
                <input type="tel" maxlength="1" inputmode="numeric" pattern="\d" 
                       class="pin-box" required onkeypress="return /[0-9]/.test(event.key)">
            <?php endfor; ?>
        </div>

        <input type="hidden" name="user_login" id="user_login_hidden">

        <button type="submit" class="btn btn-primary btn-block mt-3">Login</button>
    </form>
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Lobibox -->
<script src="https://cdn.jsdelivr.net/npm/lobibox@1.2.7/dist/js/lobibox.min.js"></script>

<script>
/* --------------------------------------------------------- */
/* PIN INPUT LOGIC */
/* --------------------------------------------------------- */
const inputs = document.querySelectorAll('.pin-box');
const hiddenInput = document.getElementById('user_login_hidden');

inputs.forEach((input, index) => {

    input.addEventListener('input', (e) => {
        e.target.value = e.target.value.replace(/\D/, '');

        if(e.target.value !== '') input.classList.add('filled');
        else input.classList.remove('filled');

        if(e.target.value.length === 1 && index < inputs.length - 1) {
            inputs[index + 1].focus();
        }

        hiddenInput.value = Array.from(inputs).map(i => i.value).join('');

        if(hiddenInput.value.length === 8) {
            showLoader();
            document.getElementById('loginForm').submit();
        }
    });

    input.addEventListener('keydown', (e) => {
        if(e.key === "Backspace" && input.value === "" && index > 0) {
            inputs[index - 1].focus();
        }
    });

    input.addEventListener('focus', (e) => e.target.select());
});

/* --------------------------------------------------------- */
/* LOADER CONTROL */
/* --------------------------------------------------------- */
function showLoader() {
    document.querySelector(".loader-overlay").style.display = "flex";
}

/* --------------------------------------------------------- */
/* AUTO-NOTIFICATION IF <notify> EXISTS & AUTO-FOCUS FIRST INPUT */
/* --------------------------------------------------------- */
document.addEventListener("DOMContentLoaded", function() {
    // Focus first input
    const firstInput = document.querySelector('.pin-box');
    if(firstInput) firstInput.focus();

    // Existing notification logic
    const msg = document.querySelector("notify");
    if (msg) {
        Lobibox.notify('error', {
            size: 'mini',
            position: 'top full',
            delay: 4500,
            msg: msg.innerHTML
        });
    }
});

 
</script>

</body>
</html>
