<?php 
include __DIR__ . '/user-ssinclude/user-init.php';
include __DIR__ . '/user-ssinclude/user-sessions.php';
include __DIR__ . '/user-ssinclude/user-header.php';

// 📌 Charger les derniers fichiers du user connecté
$employeeId = $sessionData['EMPLOYEE_ID'];

$sql = "
SELECT 
    f.file_id,
    f.name AS file_name,
    f.file_path,
    f.created_on,
    f.file_size
FROM employee_files ef
JOIN files f ON f.file_id = ef.file_id
WHERE ef.employee_id = :eid
ORDER BY f.created_on DESC
LIMIT 3
";
$stmt = $db->prepare($sql);
$stmt->execute([':eid' => $employeeId]);
$rs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div id="content" class="p-4 pt-5 w-100">

    <!-- Infos Utilisateur -->
    <div class="card mb-4 shadow">
        <div class="card-body">
            <h5 class="card-title">
                Bonjour 👋 <?= htmlspecialchars($sessionData['EMPLOYEE_FIRSTNAME']) ?>
            </h5>

            <div class="row">

                <div class="col-8 d-flex flex-column justify-content-center">

                    <p class="card-text mb-1">
                        <strong>Nom :</strong> 
                        <?= htmlspecialchars($sessionData['EMPLOYEE_LASTNAME']) ?>
                    </p>

                    <p class="card-text mb-1">
                        <strong>Prénom :</strong> 
                        <?= htmlspecialchars($sessionData['EMPLOYEE_FIRSTNAME']) ?>
                    </p>

                    <p class="card-text mb-0">
                        <strong>Matricule :</strong> 
                        <?= htmlspecialchars($sessionData['EMPLOYEE_ID_NUMBER']) ?>

                        <?php
                        // Déterminer la couleur du badge selon le groupe
                        $group = $sessionData['EMPLOYEE_GROUP']; // Valeur par défaut
                        $color = 'secondary';
                        switch ($group) {
                            case 'A': $color = 'success'; break;    // vert
                            case 'B': $color = 'warning'; break;    // jaune
                            case 'C': $color = 'danger'; break;     // rouge
                            case 'D': $color = 'primary'; break;     // bleu 
                        }
                        ?>
                        <span class="badge badge-<?= $color ?>">GROUPE <?= htmlspecialchars($group) ?></span>
                    </p>

                </div>

                <div class="col-4 text-center">
                    <img src="/user-assets/img/avatar-placeholder.png"
                         class="img-fluid rounded-circle shadow"
                         style="max-width: 120px;"
                         alt="Photo utilisateur">
                </div>
            </div>
        </div>
    </div>


    <!-- Fichiers récents -->
    <div class="card mb-4 shadow">
        <div class="card-header bg-light">
            <i class="fas fa-clock mr-2"></i> Documents récemment transmis
        </div>

        <div class="card-body">
            <div class="row text-center">

                <?php if (empty($rs)): ?>
                    <div class="col-12 text-muted p-3">
                        Aucun document récemment transmis.
                    </div>
                <?php else: ?>

                    <?php foreach ($rs as $row): ?>

                        <?php
                        // Déterminer l’icône selon extension
                        $ext = strtolower(pathinfo($row['file_name'], PATHINFO_EXTENSION));

                        $icon = match($ext) {
                            'jpg','jpeg' => "jpg.png",
                            'png'        => "png.png",
                            'pdf'        => "pdf.png",
                            'doc'        => "doc.png",
                            'docx'       => "docx.png",
                            default      => "unknown.png"
                        };

                        // Lien fichier
                        $cid = encrypt_data($row['file_id']);
                        ?>

                        <div class="col-4 mb-3">
                            <a href="dw?<?= $cid ?>" class="text-decoration-none" data-loader="off" target="_blank">
                                <img src="/user-assets/img/files/<?= $icon ?>" 
                                     class="img-fluid mb-2" 
                                     style="width:60px;">
                                <div class="file-name"><?= htmlspecialchars($row['file_name']) ?></div>
                            </a>
                        </div>

                    <?php endforeach; ?>

                <?php endif; ?>

            </div>
        </div>
    </div>


    <!-- Mes dossiers -->
    <div class="card mb-4 shadow">
        <div class="card-header bg-light">
            <i class="fas fa-folder mr-2"></i> Mes dossiers
        </div>

        <?php
        // Charger uniquement les dossiers racine
        $sql = "SELECT folder_id, name, visibility 
                FROM folders
                WHERE (parent_id IS NULL OR parent_id = 0)
                  AND active = 1
                ORDER BY ord ASC";
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $folders = $stmt->fetchAll(PDO::FETCH_ASSOC);
        ?>

        <div class="card-body">
            <div class="row text-center">

                <?php foreach ($folders as $folder): ?>

                    <?php 
                        $cid = encrypt_data($folder['folder_id']);
                        $icon = (($folder['visibility'] ?? 'private') === "public")
                                ? "/user-assets/img/files/folder.png"
                                : "/user-assets/img/files/folder-private.png";
                    ?>

                        <div class="col-4 mb-3 text-center folder-item"
                            onclick="goTo('<?php echo user_listing ?>?fid=<?= $cid ?>')"
                            style="cursor:pointer;"
                            data-loader="on">

                        <img src="<?= $icon ?>" 
                             class="img-fluid mb-2"
                             style="width:60px;" 
                             alt="Dossier">

                        <div class="small">
                            <?= htmlspecialchars($folder['name']) ?>
                        </div>
                    </div>

                <?php endforeach; ?>

            </div>
        </div>
    </div>

</div>

<?php 
include __DIR__ . "/user-ssinclude/user-footer.php";
?>
