/* ================================================
   GLOBAL LOADER CONTROL
   Used everywhere in user interface
================================================ */

/* Show loader */
function showLoader() {
    $(".loader-overlay").fadeIn(100); // jQuery fadeIn pour effet plus doux
}

/* Hide loader */
function hideLoader() {
    $(".loader-overlay").fadeOut(100);
}

/* Redirect with loader */
function goTo(url) {
    showLoader();
    setTimeout(function () {
        window.location.href = url;
    }, 80);
}
 
/* ================================================
   ON PAGE LOAD -> hide loader
================================================ */
$(document).ready(function () {
    hideLoader();

    /* SIDEBAR TOGGLE */
    $('#sidebarCollapse').on('click', function () {
        $('#sidebar, .overlay').toggleClass('active');
    });

    // Close sidebar when clicking overlay or close button
    $('.overlay, #sidebarClose').on('click', function () {
        $('#sidebar, .overlay').removeClass('active');
    });

    /* AUTO APPLY LOADER TO ANY LINK WITH data-loader="on" */
    $(document).on('click', 'a[data-loader="on"]', function (e) {
        e.preventDefault();
        goTo($(this).attr('href'));
    });
});

/* ================================================
   SHOW LOADER WHEN LEAVING PAGE
================================================ */
//$(window).on('beforeunload', function () {
//    showLoader();
//});
