<?php
/**
 * Envoie un SMS via l'API L2T
 */
function sendSMS($mobile, $message, $sender, $key) {
    $baseUrl = "https://api.l2t.io/tn/v0/api/api.aspx";

    // Préparer les paramètres
    $params = [
        'fct'    => 'sms',
        'key'    => $key,
        'mobile' => $mobile,
        'sms'    => substr($message, 0, 160), // limite 160 caractères
        'sender' => $sender
    ];

    // Construire URL avec query string
    $url = $baseUrl . '?' . http_build_query($params);

    // Initialiser cURL
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL            => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HEADER         => false,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_CONNECTTIMEOUT => 30,
        CURLOPT_TIMEOUT        => 30,
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        $result = [
            'success' => false,
            'error'   => curl_error($ch)
        ];
    } elseif ($httpCode != 200) {
        $result = [
            'success' => false,
            'error'   => "HTTP Code $httpCode",
            'response'=> $response
        ];
    } else {
        $result = [
            'success' => true,
            'response'=> $response
        ];
    }

    curl_close($ch);
    return $result;
}

// --- Paramètres pour ton SMS ---
$key     = "JZ0nzJVBzwWyRMx5yLhbvrj/lxWMDGy//9SsUyydLxws4X8V0fs0PR3gwJyoQU3sm08Igfg0rfjhw2Wc0IoVssyGWBRuhIeoeHQWUAb01V4=";
$mobile  = "21625206768";   // numéro en format international
$sender  = "Tech Fuse";
$message = "Bonjour, ceci est un test depuis l'API Tunisiesms. été bien en f être";

 $baseUrl = "https://api.l2t.io/tn/v0/api/api.aspx";



// Envoi
$response = sendSMS($mobile, $message, $sender, $key);

echo "<pre>";
print_r($response);
echo "</pre>";
?>
