<?php
/* 
----------------------------------------------------------
  MODULE : APP INIT
  V1.0 / 2018
  AUTHOR : SGHAIER MAHMOUD  
----------------------------------------------------------
*/
require_once(__DIR__.'/app-config.php');
require_once(__DIR__.'/app-helpers.php');
require_once(__DIR__.'/lang/fr-fr.php');
/* 
--- db connect   --- 
*/
try
{
    $database = new DbConnection();
    $db = $database->openConnection();
}
catch (PDOException $e)
{
    echo "There is some problem in connection: " . $e->getMessage();
}
/* 
--- db grid - global paging option --- 
*/
$paging_options = array(  
    'db_handle'  => $db,
    'using_bound_values' => true ,
    'text_prev'  => '<i class="fa fa-step-backward" aria-hidden="true"></i>',  
    'text_next'  => '<i class="fa fa-step-forward" aria-hidden="true"></i>',  
    'text_first' => '<i class="fa fa-fast-backward" aria-hidden="true"></i>',  
    'text_last'  => '<i class="fa fa-fast-forward" aria-hidden="true"></i>',  
    'class_live_links'              => 'page-item',  
    'class_current_page'            => 'active',  
    'class_ul'                      => 'pagination justify-content-end',
    'max_links_between_ellipses'    => 3,      // This MUST be an odd number, or things will break :/
    'max_links_outside_ellipses'    => 2,  
    'class_dead_links'              => 'page-item disabled',  
);  
?>