<?php
/* 
----------------------------------------------------------
  PAGE : DEFAULT DASHBOARD   
  V1.0 / 2019 / 2025 
  AUTHOR : SGHAIER MAHMOUD  
----------------------------------------------------------
*/
require_once('ssinclude/app-init.php');
require_once('ssinclude/app-session.php');
require_once('ssinclude/partials/header.php');
?>
<?php
 
 ?>
 
<!-- ===  BREADCRUMBS === -->  
<div class="breadcome-area">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="breadcome-list shadow-sm mg-t-15-b-0">
                            <!--  row : title -->
                                <div class="row">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                                    <div class="breadcome-heading">
                                            <h5 class="m-0"> <?php echo DASHBOARD_TITLE?>   </h5> 
                                    </div>
                                </div> 
                                <div class="col-lg-6 col-md-6 col-sm-6 col-6" >
                                        <ul class="breadcome-menu">
                                        <li><a href="#"><?php echo HOME?> </a> <span class="bread-slash">/</span> </li>
                                        <li><span class="bread-blod"> <?php echo DASHBOARD_TITLE?>    </span></li>
                                    </ul>
                                </div>
                            </div> <!-- .row --> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
<!-- /=== BREADCRUMBS ===  -->  
<!-- ===  STATS === -->  
<!-- STAT BLOCK A -->
<div class="widgets-area mg-tb-15">
            <div class="container-fluid">
                <div class="row">
<!--  A.1 -->
<div class="col-12">
    <div class="hpanel widget-int-shape mg-t-15-b-0">
        <div class="panel-body">

            <div class="stats-title float-left">
                <h4>Document récemment transmis</h4>
            </div>
            <div class="stats-icon float-right">
                <i class="fa fa-laptop"></i>
            </div>


<?php

// SQL corrigé
$sql = "
SELECT 
    e.employee_id,
    e.first_name,
    e.last_name,
    e.id_number,
    e.last_logged_in,

    f_last.name AS last_file_name,
    f_last.file_id,
    f_last.file_path AS last_file_path,
    f_last.created_on,
    f_last.file_size,

    COUNT(ef.file_id) AS total_files,

    n.id_notification,
    n.sms_sent,
    n.email_sent,
    n.push_sent,
    n.is_read,
    n.created_on AS notif_created_on

FROM employees e

-- 🔥 Only employees who actually have files
INNER JOIN employee_files ef 
    ON e.employee_id = ef.employee_id

-- 🔥 Only join last file (guaranteed non-null)
INNER JOIN files f_last 
    ON f_last.file_id = (
        SELECT f2.file_id
        FROM employee_files ef2
        JOIN files f2 ON ef2.file_id = f2.file_id
        WHERE ef2.employee_id = e.employee_id
        ORDER BY f2.created_on DESC
        LIMIT 1
    )

-- 🔥 Last notification (may be null → keep LEFT)
LEFT JOIN notifications n
    ON n.id_notification = (
        SELECT n2.id_notification
        FROM notifications n2
        WHERE n2.employee_id = e.employee_id
        ORDER BY n2.created_on DESC
        LIMIT 1
    )

GROUP BY 
    e.employee_id,
    e.first_name,
    e.last_name,
    e.id_number,
    e.last_logged_in,
    f_last.name,
    f_last.file_id,
    f_last.file_path,
    f_last.created_on,
    f_last.file_size,
    n.id_notification,
    n.sms_sent,
    n.email_sent,
    n.push_sent,
    n.is_read,
    n.created_on

ORDER BY f_last.created_on DESC
LIMIT 5;




";

// Exécution
$rs = $db->query($sql)->fetchAll(PDO::FETCH_ASSOC);

?>

<div class="grid-inner">
<table class="table table-hover">
    
    
    <tbody id="the-grid">
    <?php foreach ($rs as $row): ?>

        <?php
            // Icone fichier
            $ext = strtolower(pathinfo($row['last_file_name'], PATHINFO_EXTENSION));

            $icon = match($ext) {
                'jpg','jpeg' => "jpg.png",
                'png'        => "png.png",
                'pdf'        => "pdf.png",
                'doc'        => "doc.png",
                'docx'       => "docx.png",
                default      => "unknown.png"
            };

            // ID sécurisé
            $cid = encrypt_data($row['employee_id']);

            // surlignage optionnel
            $bg = (isset($last_line) && $row['employee_id'] == $last_line)
                    ? ' style="background-color:#e6f9ff"' : '';

            // lien fichier
            $fileUrl = "dw?" . encrypt_data($row['file_id']);
        ?>

        <tr id="<?= $cid ?>" <?= $bg ?>>
 
            <td rel="noClickDetect">
                <a style="display:flex;align-items:center" href="<?= $fileUrl ?>" target="_blank">
                    <img class="file-icon" src="assets/img/files/<?= $icon ?>" 
                         style="max-width:40px;margin-right:10px;">
                    <div>
 
                        <b style="color:#555 !important">
                            <?= htmlspecialchars($row['last_file_name']) ?>
                        </b>
                        <div class="text-muted small">
                            Pour <?= htmlspecialchars($row['first_name'].' '.$row['last_name']) ?> M : <?= htmlspecialchars($row['id_number']) ?> <br> 
                           
                            (  <?= formatFileSize($row['file_size']) ?>)
                           
                        </div>
                    </div>
                </a>
            </td>
           
            <td rel="noClickDetect">        
		<div class="d-flex flex-row align-items-center"> 
                <span class="<?= $row['sms_sent'] ? 'bg-success' : 'bg-danger' ?> rounded-circle colored-circle"></span> 
                <span> SMS </span> 
            </div>
        </td>

        <td rel="noClickDetect">
            <div class="d-flex flex-row align-items-center"> 
                <span class="<?= $row['push_sent'] ? 'bg-success' : 'bg-danger' ?> rounded-circle colored-circle"></span> 
                <span> PUSH </span> 
            </div>
        </td>

        <td rel="noClickDetect">
            <div class="d-flex flex-row align-items-center"> 
                <span class="<?= $row['email_sent'] ? 'bg-success' : 'bg-danger' ?> rounded-circle colored-circle"></span> 
                <span> EMAIL </span> 
            </div>
        </td>

  
              

            </span> 
            </td>

            

            <td rel="noClickDetect">
                <small>Envoyé le <?= $row['created_on'] ?>  </small>
            </td>
        </tr>

    <?php endforeach; ?>
    </tbody>
</table>
</div>

        </div>
    </div>
</div>
<!-- / A.1 -->

                 
                 
                  
                </div>
            </div>
        </div>
<!-- /STAT BLOCK A -->


<!-- STAT BLOCK B   -->
        <div class=" mg-tb-30">
            <div class="container-fluid">
                <div class="row">
       <!--  A.2 -->
<div class="col-12">
    <div class="hpanel widget-int-shape mg-t-15-b-0">
        <div class="panel-body">

            <div class="stats-title float-left">
                <h4>Derniers employés connectés</h4>
            </div>
            <div class="stats-icon float-right">
                <i class="fa fa-user"></i>
            </div>

<?php
// Get top 5 employees by last login
$sql = "
SELECT 
    employee_id,
    first_name,
    last_name,
    id_number,
    phone_number,
    last_logged_in
FROM employees
ORDER BY last_logged_in DESC
LIMIT 5
";

$rs = $db->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="grid-inner">
<table class="table table-hover">
    
    <tbody>
        <?php foreach ($rs as $row): ?>
<tr>
    <td style="width:25%;">
        <b><?= htmlspecialchars((string)($row['first_name'] ?? '') . ' ' . ($row['last_name'] ?? '')) ?></b>
    </td>
    <td style="width:20%;">
      <small> Matricule : <br> <?= htmlspecialchars((string)($row['id_number'] ?? '')) ?></small> 
    </td>
    <td style="width:25%;">
       <small> Téléphone : <br> <?= htmlspecialchars((string)($row['phone_number'] ?? '')) ?> </small> 
    </td>
    <td style="width:30%;">
        <small>
            Dernière connexion : <br>
            <?= htmlspecialchars((string)($row['last_logged_in'] ?? '')) ?>
        </small>
    </td>
</tr>

        <?php endforeach; ?>
    </tbody>
</table>
</div>

        </div>
    </div>
</div>
<!-- / A.2 -->

                
                
                </div>
            </div>
        </div>
<!-- STAT BLOCK B   --> 
<!-- /=== CONTENT ZONE === -->  
<?php
require_once('ssinclude/partials/footer.php');
?>