<?php
/* PAGE: GLOBAL NOTIFICATIONS GRID */
require_once(__DIR__.'/ssinclude/app-init.php');
require_once(__DIR__.'/ssinclude/app-session.php');
require_once(__DIR__.'/ssinclude/classes/class.pagination.php');

$power = getSessionData($sessionId, 'USER_POWER');
if ($power !== "AD" && $power !== "RH") { header("location:" . page_login_authoriser . "?logout=true"); exit(); }
require_once(__DIR__.'/ssinclude/partials/header.php');

$table_name = "global_notifications";
$table_key  = "id_global";

$grid_script = page_global_notifications_grid;
$edit_script = global_notifications_edit;
$edit_window = "false";

$rec_by_page = 1000000;
$pg = isset($_REQUEST['pg']) ? $_REQUEST['pg'] : 1;
if (!is_numeric($pg)) $pg = 1;

$paging_options['url'] = $grid_script.'?pg=*VAR*';
$paging_options['results_per_page'] = $rec_by_page;

$qry_mode = isset($_REQUEST['actionmode']) ? $_REQUEST['actionmode'] : "";
$qry_id   = isset($_REQUEST['frmid']) ? $_REQUEST['frmid'] : "";
$last_line = request_to_session("frmid");
if (!empty($last_line) && !is_numeric($last_line)) $last_line = decrypt_data($last_line);

$sql_where = " WHERE 1=1 ";

$order_by_list = "[$table_key]";
$default_arrow_state = 'dw';
$default_arrow_index = 0;
$frm_arrow_state = isset($_REQUEST['frmarrowstate']) ? $_REQUEST['frmarrowstate'] : $default_arrow_state;
$frm_arrow_index = isset($_REQUEST['frmarrowindex']) ? $_REQUEST['frmarrowindex'] : $default_arrow_index;
$order_by = get_order_by($frm_arrow_index, $frm_arrow_state, $order_by_list);

switch ($qry_mode) {
    case "": db_grid(); break;
}

function db_grid() {
    global $table_name, $table_key, $sql_where, $order_by, $db, $pg, $paging_options, $rec_by_page, $grid_script, $last_line;
    global $allow_remove;
?>
<!-- ===  BREADCRUMBS === -->  

<?php if (verif_get('err')=="sucupd") { ?>
    <notify class="notify-success">  La mise à jour a été effectuée avec succès  </notify>
<?php } ?>

<?php if (verif_get('err')=="sucadd") { ?>
    <notify class="notify-success">  La notification a été ajoutée avec succès.</notify>
<?php } ?>

<div class="breadcome-area">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-12">

                <div class="breadcome-list shadow-sm search-forms">
                
                <!-- first row : title -->
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                        <ul class="breadcome-menu mg-b-10">
                            <li><a href="#"><?php echo HOME?> </a> <span class="bread-slash">/</span></li>
                            <li><span class="bread-blod"> <?php echo LIST_GLOBAL_NOTIFICATION_TITLE?> </span></li>
                        </ul>
                    </div>
                </div>  
                
                <!-- 2nd row : search -->
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="breadcome-heading">                                        
                            <div class="row no-gutters">
                                <div class="col-lg-6 col-md-6 col-sm-12 col-12"> 
                                    <div role="search" class="sr-input-func float-left">
                                        <input name="search-trigger" id="search-trigger" value="" type="text" placeholder="Recherche..." class="search-int form-control">  
                                        <a class="ico-sr-help"><i class="fa fa-search"></i></a>
                                    </div>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div> 

                </div>

            </div>
        </div>
    </div>
</div>
<!-- /=== BREADCRUMBS ===  --> 


<div class="container-fluid mg-b-15">
    <div class="row">
        <div class="col-lg-12">
            <div class="content-wrap">

                <div class="row clearfix">
                    <div class="col-lg-6"> 
                        <h4><?php echo LIST_GLOBAL_NOTIFICATION_TITLE?>  </h4>
                    </div>

                    <div class="col-lg-6"> 
                        <div class="grid-item">
                          <button type="button" class="btn btn-success" id="edit-trigger"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> 
                          <?php echo MODIFY_TITLE?>  </button>

                          <?php if ( $allow_remove ) { ?> 
                          <button type="button" class="btn btn-danger" id="delete-trigger"><i class="fa fa fa-trash-o" aria-hidden="true"></i> 
                          <?php echo REMOVE_TITLE?>  </button>  
                          <?php  } ?> 

                          <button type="button" class="btn btn-primary" id="add-trigger"><i class="fa fa-plus" aria-hidden="true"></i> 
                          <?php echo ADD_GLOBAL_NOTIFICATION_TITLE?> </button>
                        </div>
                    </div>
                </div>

                <form id="grid-form" action="<?php echo $grid_script ?>" method="GET">
                <?php view_hidden('grid'); ?>

<?php
$sql = "SELECT * FROM $table_name $sql_where ORDER BY $order_by";

try {
    $pagination = new pagination($pg, $sql, $paging_options);
    $pagination->execute();
} catch (paginationException $e) { echo $e; exit(); }

if ($pagination->success == true) {
    $rs = $pagination->resultset->fetchAll();
?>
                <div class="grid-inner">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th style="width:2%"><input class="i-checks" type="checkbox" id="chkselall" /></th>
                                <th style="width:40%">Notification</th>
                                <th style="width:20%">Dates</th>
                                <th style="width:15%">Poussée le</th>
                                <th style="width:15%">Action</th>
                            </tr>
                        </thead>
                        <tbody>

<?php foreach ($rs as $row) {
    $cid = encrypt_data($row[$table_key]);
    $bg = (is_numeric($last_line) && $row[$table_key] == $last_line) ? ' style="background-color:#e6f9ff"' : '';
?>
<tr id="<?php echo $cid ?>" <?php echo $bg ?>>
    <td>
        <?php if (empty($row['pushed_on'])) { ?>
        <input class="i-checks" type="checkbox" name="chksel" value="<?php echo $cid ?>"></td>
        <?php } ?> 
    <td>
        <?php
            $color = 'secondary';
            switch ($row['schedule_group']) {
                case 'A': $color = 'success'; break;
                case 'B': $color = 'warning'; break;
                case 'C': $color = 'danger'; break;
                case 'D': $color = 'primary'; break;
                case 'ALL': $color = 'info'; break;
            }
        ?>
        <span class="badge badge-<?= $color ?>"> DESTINATION  : <?= htmlspecialchars($row['schedule_group']) ?></span><br> 
        
        <b><?php echo htmlspecialchars($row['title'] ?? '') ?></b><br>
        <small><?php echo nl2br(htmlspecialchars($row['message'] ?? '')) ?></small><br>
        <?php if (!empty($row['link'])) { ?>
            <a href="<?php echo htmlspecialchars($row['link']) ?>" target="_blank">Lien</a>
        <?php } ?>
    </td>

    <td>
        <small>C: <?php echo $row['created_on'] ?><br>M: <?php echo $row['updated_on'] ?></small>
    </td>

    <td>
        <div class="d-flex flex-row align-items-center"> 
            <span class="<?= !empty($row['pushed_on']) ? 'bg-success' : 'bg-danger' ?> rounded-circle colored-circle"></span> 
            <small><?php echo $row['pushed_on'] ?: '-' ?></small>
        </div>
    </td>

    <td>
        <?php if (empty($row['pushed_on'])) { ?>
             <a class="btn ico-push" data-toggle="tooltip" data-original-title="<?php echo PUSH_TITLE ?>">
                <i class="fa fa-send" aria-hidden="true"></i>
            </a>
            <a class="btn ico-edit"><i class="fa fa-pencil-square-o"></i></a>
        <?php } ?>

        <?php if ($allow_remove) { ?>
                <a class="btn ico-delete" data-toggle="tooltip" data-original-title="<?php echo REMOVE_TITLE ?>">
                    <i class="fa fa-trash-o" aria-hidden="true"></i>
                </a>
            <?php } ?>

    </td>
</tr>
<?php } ?>
                        </tbody>
                    </table>
                </div>

<?php } ?>
                </form>

            </div>
        </div>
    </div>
</div>
<?php }
require_once(__DIR__.'/ssinclude/partials/footer.php');
?>
