<?php
/* 
----------------------------------------------------------
  PAGE : GLOBAL NOTIFICATIONS MASK     
  V1.0 / 2018 / 2025 
  AUTHOR : SGHAIER MAHMOUD  
----------------------------------------------------------
*/

require_once(__DIR__.'/ssinclude/app-init.php');
require_once(__DIR__.'/ssinclude/app-session.php');

$power = getSessionData($sessionId, 'USER_POWER');
if ($power !== "AD" && $power !== "RH") {
    header("location:" . page_login_authoriser . "?logout=true");
    exit();
}

require_once(__DIR__.'/ssinclude/partials/header.php');

// grid scripts/options 
$grid_script = page_global_notifications_grid;
$edit_script = global_notifications_edit;
$edit_window = "false";

// get action
$qry_mode = isset($_REQUEST['actionmode']) ? $_REQUEST['actionmode'] : "";
$qry_id    = isset($_REQUEST['frmid']) ? $_REQUEST['frmid'] : "";
$qry_id_c  = (!empty($qry_id)) ? decrypt_data($qry_id) : "";

if ($qry_mode == "edit" && !is_numeric($qry_id_c)) exit();

// main table
$table_name = "global_notifications";
$table_key  = "id_global";

// fields
$main_tbl_db = array(
    'title'   => '',
    'message' => '',
    'link'    => '',
    'schedule_group' => 'ALL', // valeur par défaut
);

/* 
----------------------------------------------------------
  SWITCHER     
----------------------------------------------------------
*/

switch ($qry_mode) {
    case "edit":
        mask("edit", "", true);
        break;

    case "add":
        mask("add", "", true);
        break;

    case "update":
        update();
        break;

    case "addnew":
        addnew();
        break;
}

/* MASK (EDIT / ADD) */
function mask($prmmode, $prmmessage, $prmstatus)
{
    global $main_tbl_db, $table_name, $table_key, $qry_id_c, $db, $edit_script, $grid_script;
     global $next_mode;
    // $next_mode = ($prmmode == 'edit') ? 'update' : 'addnew';
    if ($prmmode=='edit') $next_mode = "update";
    if ($prmmode=='add') $next_mode = "addnew";

    $method = $_SERVER['REQUEST_METHOD'];

    if ($method != "POST") {

        if ($prmmode == "edit") {
            try {
                $sql = "SELECT * FROM $table_name WHERE $table_key = $qry_id_c";
                $row = $db->query($sql)->fetch();

                foreach ($main_tbl_db as $key => $value) {
                    $main_tbl_db[$key] = $row[$key];
                }
            } catch (PDOException $e) {
                notify_error($e->getMessage());
            }
        }

    } else {

        foreach ($main_tbl_db as $key => $value) {
            $main_tbl_db[$key] = verif_posted($key);
        }
    }

    if (!empty($prmmessage)) {
        ($prmstatus) ? notify_success($prmmessage) : notify_error($prmmessage);
    }
?>

<!-- ===  BREADCRUMBS === -->  
<div class="breadcome-area">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="breadcome-list shadow-sm">

                    <div class="row">

                        <div class="col-lg-6">
                            <h5 class="m-0">
                                <?php echo ($prmmode == "edit") ? EDIT_GLOBAL_NOTIFICATION_TITLE : ADD_GLOBAL_NOTIFICATION_TITLE; ?>
                            </h5>
                        </div>

                        <div class="col-lg-6">
                            <ul class="breadcome-menu">
                                <li><a href="#"><?php echo HOME ?></a> <span class="bread-slash">/</span></li>
                                <li><span class="bread-blod">
                                    <?php echo ($prmmode == "edit") ? EDIT_GLOBAL_NOTIFICATION_TITLE : ADD_GLOBAL_NOTIFICATION_TITLE; ?>
                                </span></li>
                            </ul>
                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- === CONTENT === -->  
<div class="container-fluid mg-b-15">
<div class="row">
<div class="col-lg-12">

<div class="content-wrap">

<form action="<?php echo $edit_script ?>" method="POST" id="mask-form" class="needs-validation mask-form" novalidate>
<?php view_hidden('mask'); ?>

<div class="row">
    <div class="col-lg-6">
    </div>
    <div class="col-lg-6 text-right">
       <div class="mask-item">
                            <button type="button" class="btn" id="cancel-trigger"><i class="fa fa-chevron-left" aria-hidden="true"></i> <?php echo CANCEL_TITLE?>  </button>
                            <button type="button" class="btn btn-primary" id="validate-trigger"><i class="fa fa-check" aria-hidden="true"></i> <?php echo VALIDATE_TITLE?> </button>
        </div>
    </div>
</div>

<div class="row">

    <div class="col-lg-6">

        <div class="form-group">
            <label>Titre</label>
            <input required name="title" type="text" class="form-control"
                value="<?php echo htmlspecialchars($main_tbl_db['title']) ?>">
            <div class="invalid-tooltip">Titre requis</div>
        </div>

        <div class="form-group">
            <label>Message</label>
            <textarea required name="message" class="form-control" rows="5"><?php echo htmlspecialchars($main_tbl_db['message']) ?></textarea>
            <div class="invalid-tooltip">Message requis</div>
        </div>

       

    </div>

            <div class="col-lg-6">

            <div class="form-group">
            <label for="schedule_group">Groupe horaire</label>
            <?php 
                drop_down(
                    $main_tbl_db['schedule_group'], // valeur actuelle
                    "schedule_group",               // nom du champ
                    "A;B;C;D;ALL",                    // valeurs
                    "Groupe A;Groupe B;Groupe C;Groupe D;Tous", // libellés lisibles
                    "[ Sélectionner ]",             // placeholder
                    " required ",                   // attributs
                    false,
                    "form-control"
                );
            ?>
            <div class="invalid-tooltip">Sélectionner un groupe horaire</div>
            <span class="help-block small"></span>
        </div>


        <div class="form-group">
            <label>Lien (optionnel)</label>
            <input name="link" type="text" class="form-control"
                value="<?php echo htmlspecialchars($main_tbl_db['link']) ?>">
        </div>

    </div>


</div>

</form>

</div>
</div>
</div>
</div>

<?php
}

/* ADD NEW */
function addnew()
{
    global $main_tbl_db, $table_name, $db, $grid_script, $edit_window;

    foreach ($main_tbl_db as $key => $value) {
        $main_tbl_db[$key] = verif_posted($key);
    }

    $columns = implode(", ", array_keys($main_tbl_db));
    $params = ":" . implode(", :", array_keys($main_tbl_db));

    $sql = "INSERT INTO $table_name ($columns) VALUES ($params)";

    try {
        $stmt = $db->prepare($sql);
        $stmt->execute($main_tbl_db);

        $url = $grid_script . "?err=sucadd&frmid=" . encrypt_data($db->lastInsertId());
        js_redirect($url);

    } catch (PDOException $e) {
        mask('add', $e->getMessage(), false);
    }
}

/* UPDATE */
function update()
{
    global $main_tbl_db, $table_name, $table_key, $qry_id_c, $qry_id, $db, $grid_script;

    foreach ($main_tbl_db as $key => $value) {
        $main_tbl_db[$key] = verif_posted($key);
    }

    $sql = "UPDATE $table_name SET ";
    $i = 0;

    foreach ($main_tbl_db as $key => $value) {
        $sql .= "$key = :$key";
        if (++$i < count($main_tbl_db)) {
            $sql .= ", ";
        }
    }

    $sql .= " WHERE $table_key = $qry_id_c";

    try {
        $stmt = $db->prepare($sql);
        $stmt->execute($main_tbl_db);

        js_redirect($grid_script . "?err=sucupd&frmid=".$qry_id) ;

    } catch (PDOException $e) {
        mask('edit', $e->getMessage(), false);
    }
}

require_once(__DIR__.'/ssinclude/partials/footer.php');
?>
