<?php
/* 
----------------------------------------------------------
  PAGE : FOLDER  GRID      
  V1.0 / 2018-2025 
  AUTHOR : SGHAIER MAHMOUD  
----------------------------------------------------------
*/
require_once(__DIR__.'/ssinclude/app-init.php');
require_once(__DIR__.'/ssinclude/app-session.php');
require_once(__DIR__.'/ssinclude/classes/class.pagination.php');
// power test security 
$power = getSessionData($sessionId, 'USER_POWER');
if ($power !== "AD" && $power !== "RH") {
    header("location:" . page_login_authoriser . "?logout=true");
    exit();
}
require_once(__DIR__.'/ssinclude/partials/header.php');
// main table/key 
$table_name="folders";
$table_key="folder_id";
// grid scripts/options 
$grid_script  = page_folder_grid;
$edit_script = page_folder_edit;  
$edit_window = "false"; // if true modal mode     
//  build paging session 
$rec_by_page = 1000000 ; // no paging 
//if ($rec_by_page=="") {$rec_by_page = default_rec_by_page ;}
if (isset($_REQUEST['pg'])) $pg=$_REQUEST["pg"]; else $pg=1 ;
if (!is_numeric( $pg ) ) $pg=1;
$paging_options['url'] = $grid_script.'?pg=*VAR*';
//$paging_options['results_per_page'] = $rec_by_page;
$paging_options['results_per_page'] = $rec_by_page;
// get data & action if any
if (isset($_REQUEST['actionmode'])) $qry_mode=$_REQUEST['actionmode']; else $qry_mode="";
if (isset($_REQUEST['frmid'])) $qry_id=$_REQUEST["frmid"]; else $qry_id="";
$last_line = request_to_session("frmid");
if (!empty($last_line)) {
    if (!is_numeric($last_line)) {
        $last_line = decrypt_data($last_line);
    }  
}
// prepare filtering  
// $session_name = request_to_session("sfrmName");
$str_comp_where = ""; // by users filter
$sql_where = " Where( 1=1 and " ; // grid filter prepare;
// grid sorting vars 
//$order_by_list = "['ord','statuses.status_type','statuses.status_type','statuses.status_type', 'statuses.status_type',     'statuses.status_type']";
//$default_arrow_state = 'up';
//$default_arrow_index = 0;
//if (isset($_REQUEST['frmarrowstate'])) $frm_arrow_state=$_REQUEST["frmarrowstate"]; else $frm_arrow_state=$default_arrow_state ;
//if (isset($_REQUEST['frmarrowindex'])) $frm_arrow_index=$_REQUEST["frmarrowindex"]; else $frm_arrow_index=$default_arrow_index ;
//if ($frm_arrow_index>=0) {
//    $order_by = get_order_by ($frm_arrow_index,$frm_arrow_state,$order_by_list);
// }
$order_by = " ord";
/* 
----------------------------------------------------------
  SWITCHER     
----------------------------------------------------------
*/
//  verif privilege and switch to view 
switch ($qry_mode)
{
  case "":db_grid();break;
}
/* 
----------------------------------------------------------
  DB GRID VIEW      
----------------------------------------------------------
*/
function db_grid()
{
   global  $table_name,$table_key,$sql_where,$order_by,$db,$pg,$paging_options,$rec_by_page,$grid_script; 
   global $last_line, $allow_remove; 
   ?>
<!-- ===  BREADCRUMBS === -->  
<?php if (verif_get('err')=="sucupd") { ?>
    <notify class="notify-success">  La mise à jour a été effectuée avec succès  </notify>
 <?php } ?>
<?php if (verif_get('err')=="sucadd") { ?>
  <notify class="notify-success">Le nouveau dossier a été ajouté avec succès.</notify>

 <?php } ?>
      <div class="breadcome-area">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                            <div class="breadcome-list shadow-sm search-forms">
                            <!-- first row : title -->
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                        <ul class="breadcome-menu mg-b-10">
                                                        <li><a href="#"><?php echo HOME?> </a> <span class="bread-slash">/</span>
                                                        </li>
                                                        <li><span class="bread-blod"> <?php echo LIST_FOLDER_TITLE?> </span>
                                                        </li>
                                    </ul>
                                </div>
                            </div>  <!-- .row --> 
                            <!-- 2nd row : quick search and advanced filters   -->
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="breadcome-heading">
                                    <div class="row no-gutters">
                                    <div class="col-lg-6 col-md-6 col-sm-12 col-12"> 
                                        <div role="search" class="sr-input-func float-left">
                                                <input name="search-trigger" id="search-trigger" value="" type="text" placeholder="Recherche..." class="search-int form-control">  
                                                <a class="ico-sr-help"><i class="fa fa-search"></i></a>
                                            </div>
                                    </div>
                                    <!--
                                    <div class="col-lg-6 col-md-6 col-sm-2 col-2">
                                        <a class="btn ico ico-filter float-left" data-toggle="collapse" data-target="#collapse-filter-form" aria-expanded="false" aria-controls="collapse-filter-form" title=""><i class="fa fa-sliders" aria-hidden="true"></i></a>
                                    </div> -->
                                    </div> <!-- .row --> 
                                    </div>
                                </div> <!-- col -->
                            </div> <!-- .row --> 
                            </div>
                    </div>
                </div>
            </div>
        </div>
<!-- /=== BREADCRUMBS ===  --> 
<!-- === CONTENT ZONE === -->  
 <div class="container-fluid mg-b-15">
  <div class="row">    
   <div class="col-lg-12 col-md-12 col-sm-12 col-12">
   <div class="content-wrap">  
    <div class="row clearfix">
                <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                <div class="grid-title">
                  <h4><?php echo LIST_FOLDER_TITLE?>  </h4>
               </div> 
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-6">
                   <div class="grid-item">
                      <button type="button" class="btn btn-success" id="edit-trigger"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> <?php echo MODIFY_TITLE?>  </button>
                   <?php if ( $allow_remove ) { ?>
                      <button type="button" class="btn btn-danger" id="delete-trigger"><i class="fa fa fa-trash-o" aria-hidden="true"></i> <?php echo REMOVE_TITLE?>  </button> 
                    <?php  } ?>
                      <button type="button" class="btn btn-primary" id="add-trigger"><i class="fa fa-plus" aria-hidden="true"></i> <?php echo ADD_FOLDER_TITLE?> </button>
                    </div>
                </div>
    </div>
   <form id="grid-form" name="grid-form" action="<?php echo $grid_script ?>" method="GET">
   <?php 
 // hidden control data 
view_hidden('grid');
{$sql_where = $sql_where." ( $table_name.parent_id = 0 ) and " ; }
$sql_where=substr($sql_where,0,strlen($sql_where)-4).") ";
// build sql
$sql=" 
SELECT 
$table_name.* 
FROM $table_name  
$sql_where 
ORDER BY $order_by   ";
// pagination 
try
{
    $pagination = new pagination($pg, $sql , $paging_options);  
    //$pagination->bindValue(1, 1, PDO::PARAM_INT);  
    $pagination->execute();
}
catch(paginationException $e)
{
    echo $e;
    exit();
}
//  If all was successful, we can do something with our results 
 
if ($pagination->success == true) {  

    // Get the results 
    $rs = $pagination->resultset->fetchAll();  
    ?>
    <div class="grid-inner">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th style="width:2%">
                        <input class="i-checks" type="checkbox" name="chkselall" id="chkselall" value="all"/> 
                    </th>
                    <th style="width:3%">Niv</th>
                    <th style="width:35%">Dossier</th>
                    <th class="text-center" style="width:10%">Active?</th>
                    <th style="width:30%">Dates</th>
                    <th style="width:10%">Action</th>
                </tr>
            </thead>
            <tbody id="the-grid">
                <?php  
                // --- recursive inline rendering ---
                $render_recursive = function($rows, $level = 0) use ($db, $table_name, $table_key, $order_by, $last_line, &$render_recursive) {
                    global $allow_remove; 
                    foreach ($rows as $row) {
                        $cid = encrypt_data($row[$table_key]);
                        $bg = '';

                        if (is_numeric($last_line) && $row[$table_key] == $last_line) {
                            $bg = ' style="background-color:#e6f9ff" ';
                        }

                        // indentation
                        $padding = 20 + ($level * 30);
                        ?>
                        <tr id="<?php echo $cid ?>" <?php echo $bg ?> class="bg-tr-light-2">
                            <td rel="noClickDetect">
                                <input class="i-checks" type="checkbox" name="chksel" value="<?php echo $cid ?>">
                            </td>
                             <td rel="noClickDetect" class="text-center">
                               <span class="badge">  <?php echo htmlspecialchars($row['ord']); ?> </span>
                            </td>

                            <td style="padding-left:<?php echo $padding; ?>px;">
                              <?php
                                if ($row['visibility'] == 'public') {
                                    echo '<img class="file-icon" src="assets/img/files/folder.png">';
                                } else {
                                    echo '<img class="file-icon" src="assets/img/files/folder-private.png">';
                                }
                                ?>
                                <b> <?php echo htmlspecialchars($row['name']); ?></b>
                            </td>
                            <td rel="noClickDetect" class="text-center">
                                <?php activation_status($row['active'], "active"); ?>
                            </td> 
                            <td>
                                <span class="small text-secondary">
                                    C: <?php echo $row['created_on']; ?><br> 
                                    M: <?php echo $row['updated_on']; ?>  
                                </span>
                            </td>
                            <td rel="noClickDetect">
                                <a class="btn ico-edit" data-toggle="tooltip" data-original-title="<?php echo MODIFY_TITLE; ?>">
                                    <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                                </a>
                               <?php if ( $allow_remove ) { ?>
                                <a class="btn ico-delete" data-toggle="tooltip" title=""  data-original-title="<?php echo REMOVE_TITLE?>"><i class="fa fa-trash-o" aria-hidden="true"></i></a> 
                               <?php  } ?>

                            </td>
                        </tr>
                        <?php
                        // Load subfolders recursively
                        $sqlsub = "SELECT * FROM {$table_name} WHERE parent_id = ? ORDER BY {$order_by}";
                        $stmt = $db->prepare($sqlsub);
                        $stmt->execute([$row[$table_key]]);
                        $subrs = $stmt->fetchAll();

                        if (!empty($subrs)) {
                            $render_recursive($subrs, $level + 1);
                        }
                    }
                };

                // call recursive rendering on main level
                $render_recursive($rs);
                ?>
            </tbody>
        </table>
    </div>

    <div class="row">
        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
            <div class="result-paging-block" style="display:none">
                <span>
                    <?php echo PAGING_TITLE ?> <?php echo $pagination->current_page ?>  
                    <?php echo PAGING_SEPARATOR ?>  
                    <?php echo $pagination->total_pages ?>  
                    - <?php echo $pagination->total_results; ?> <?php echo PAGING_RECORDS ?>   
                </span>
            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 col-12">
            <nav aria-label="grid navigation" class="paging-block">
                <?php //echo $pagination->links_html; ?> 
            </nav>
        </div>
    </div>
<?php } // end test $pagination->succes   ?>

 
       </form>
       </div> <!-- .content-wrap --> 
      </div> <!-- .col-lg-12 col-md-12 col-sm-12 col-12 -->  
	</div>  <!-- .row --> 
    </div> <!-- .container-fluid --> 
<!-- /=== CONTENT ZONE === -->  
<!-- === MODALS ZONE === -->  
<!-- /=== MODALS ZONE ===  -->  
<?php } // end db_grid function ?>
<?php
require_once(__DIR__.'/ssinclude/partials/footer.php');
?>