<?php
/* 
----------------------------------------------------------
  PAGE : USER GRID      
  V1.0 / 2018
  AUTHOR : SGHAIER MAHMOUD  
----------------------------------------------------------
*/


require_once(__DIR__.'/ssinclude/app-init.php');
require_once(__DIR__.'/ssinclude/app-session.php');
require_once(__DIR__.'/ssinclude/classes/class.pagination.php');

// power test security 
$power = getSessionData($sessionId, 'USER_POWER');

if ($power !== "AD" && $power !== "RH") {
    header("location:" . page_login_authoriser . "?logout=true");
    exit();
}

require_once(__DIR__.'/ssinclude/partials/header.php');


// main table/key 
$table_name="employees";
$table_key="employee_id";

// grid scripts/options 
$grid_script  = page_employee_grid;
$edit_script = page_employee_edit;  
$edit_window = "false"; // if true modal mode     

//  build paging session 
$rec_by_page = 1000000 ; // no paging 
//if ($rec_by_page=="") {$rec_by_page = default_rec_by_page ;}
if (isset($_REQUEST['pg'])) $pg=$_REQUEST["pg"]; else $pg=1 ;
if (!is_numeric( $pg ) ) $pg=1;

$paging_options['url'] = $grid_script.'?pg=*VAR*';
//$paging_options['results_per_page'] = $rec_by_page;
$paging_options['results_per_page'] = $rec_by_page;
 
// get data & action if any
if (isset($_REQUEST['actionmode'])) $qry_mode=$_REQUEST['actionmode']; else $qry_mode="";
if (isset($_REQUEST['frmid'])) $qry_id=$_REQUEST["frmid"]; else $qry_id="";

$last_line = request_to_session("frmid");
if (!empty($last_line)) {
    if (!is_numeric($last_line)) {
        $last_line = decrypt_data($last_line);
    }  
}

// prepare filtering  
$session_name = request_to_session("sfrmName");

$str_comp_where = ""; // by users filter
$sql_where = " Where( 1=1 and " ; // grid filter prepare;
 

// grid sorting vars 
$order_by_list = "[$table_key,'statuses.status_type','statuses.status_type','statuses.status_type', 'statuses.status_type',     'statuses.status_type']";
$default_arrow_state = 'dw';
$default_arrow_index = 0;
if (isset($_REQUEST['frmarrowstate'])) $frm_arrow_state=$_REQUEST["frmarrowstate"]; else $frm_arrow_state=$default_arrow_state ;
if (isset($_REQUEST['frmarrowindex'])) $frm_arrow_index=$_REQUEST["frmarrowindex"]; else $frm_arrow_index=$default_arrow_index ;
if ($frm_arrow_index>=0) {
    $order_by = get_order_by ($frm_arrow_index,$frm_arrow_state,$order_by_list);
}

 
/* 
----------------------------------------------------------
  SWITCHER     
----------------------------------------------------------
*/
//  verif privilege and switch to view 
switch ($qry_mode)
{
  case "":db_grid();break;
}

/* 
----------------------------------------------------------
  DB GRID VIEW      
----------------------------------------------------------
*/
function db_grid()
{
   global $sessionData; 
   global  $table_name,$table_key,$sql_where,$order_by,$db,$pg,$paging_options,$rec_by_page,$grid_script; 
   global $last_line, $allow_remove; 
  
   ?>
<!-- ===  BREADCRUMBS === -->  

<?php if (verif_get('err')=="sucupd") { ?>
    <notify class="notify-success">  La mise à jour a été effectuée avec succès  </notify>
 <?php } ?>

 
<?php if (verif_get('err')=="sucadd") { ?>
    <notify class="notify-success">  Le nouvel employé a été ajouté avec succès.</notify>
 <?php } ?>

      <div class="breadcome-area">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-12">


                            <div class="breadcome-list shadow-sm search-forms">
                            
                            <!-- first row : title -->
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                        <ul class="breadcome-menu mg-b-10">
                                                        <li><a href="#"><?php echo HOME?> </a> <span class="bread-slash">/</span>
                                                        </li>
                                                        <li><span class="bread-blod"> <?php echo LIST_EMP_TITLE?> </span>
                                                        </li>
                                    </ul>
                                </div>
                            </div>  <!-- .row --> 
                            
                            <!-- 2nd row : quick search and advanced filters   -->
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="breadcome-heading">
                                                                
                                    <div class="row no-gutters">
                                    <div class="col-lg-6 col-md-6 col-sm-12 col-12"> 
                                        <div role="search" class="sr-input-func float-left">
                                                <input name="search-trigger" id="search-trigger" value="" type="text" placeholder="Recherche..." class="search-int form-control">  
                                                <a class="ico-sr-help"><i class="fa fa-search"></i></a>
                                            </div>
                                    </div>
                                    <!--
                                    <div class="col-lg-6 col-md-6 col-sm-2 col-2">
                                        <a class="btn ico ico-filter float-left" data-toggle="collapse" data-target="#collapse-filter-form" aria-expanded="false" aria-controls="collapse-filter-form" title=""><i class="fa fa-sliders" aria-hidden="true"></i></a>
                                    </div> -->
                                    </div> <!-- .row --> 

                                    </div>
                                </div> <!-- col -->
                            </div> <!-- .row --> 

                            </div>

                    </div>
                </div>
            </div>
        </div>
<!-- /=== BREADCRUMBS ===  --> 


<!-- === CONTENT ZONE === -->  
 
 <div class="container-fluid mg-b-15">
  <div class="row">    
   <div class="col-lg-12 col-md-12 col-sm-12 col-12">
   <div class="content-wrap">  
 
    <div class="row clearfix">
                <div class="col-lg-6 col-md-6 col-sm-6">
                <div class="grid-title">
                  <h4><?php echo LIST_EMP_TITLE?>  </h4>
               </div> 
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6">
                   <div class="grid-item">
                      <button type="button" class="btn btn-success" id="edit-trigger"><i class="fa fa-pencil-square-o" aria-hidden="true"></i> <?php echo MODIFY_TITLE?>  </button>
                      <?php if ( $allow_remove ) { ?> 
                      <button type="button" class="btn btn-danger" id="delete-trigger"><i class="fa fa fa-trash-o" aria-hidden="true"></i> <?php echo REMOVE_TITLE?>  </button>  
                      <?php  } ?> 
                      <button type="button" class="btn btn-primary" id="add-trigger"><i class="fa fa-plus" aria-hidden="true"></i> <?php echo ADD_EMP_TITLE?> </button>
                    </div>
                </div>
    </div>
    
   <form id="grid-form" name="grid-form" action="<?php echo $grid_script ?>" method="GET">

   <?php 
   // hidden control data 
   view_hidden('grid');
 

$sql_where=substr($sql_where,0,strlen($sql_where)-4).") ";

// build sql
$sql=" 
SELECT 
$table_name.* 
 
FROM $table_name  

$sql_where 

ORDER BY $order_by   ";
 
// pagination 
try
{
    $pagination = new pagination($pg, $sql , $paging_options);  
    //$pagination->bindValue(1, 1, PDO::PARAM_INT);  
    $pagination->execute();
}
catch(paginationException $e)
{
    echo $e;
    exit();
}

    
//  If all was successful, we can do something with our results 
if($pagination->success == true)  
{  
    // Get the results 
    $rs = $pagination->resultset->fetchAll();  
     ?>
                    <div class="grid-inner">
                        <table class="table table-hover">
                            <thead>
                             <tr>
                                <th style="width:2%"><input class="i-checks" type="checkbox" name="chkselall" id="chkselall" value="all"/> </td>
                                <th style="width:30%">Employée </th>
                                <th style="width:18%">Dernier accès  </th>
                                <th style="width:5%">Active?</th>
                                <th style="width:20%">Dates </th>
                                <th style="width:13%">Action</th>
                            </tr>
                            </thead>
                            <tbody id="the-grid">

     <?php

    foreach($rs as $row)  
    { 
        //$cid= ($row[$table_key]);
        $cid= encrypt_data($row[$table_key]);
        $bg = ' ';
        if (is_numeric($last_line)) {
            if ( $row[$table_key] == $last_line ) {
                $bg = ' style="background-color:#e6f9ff" '; }
        }  
        ?>
    <!-- tr --> 
  
    <tr id="<?php echo $cid?>" <?php echo $bg?>>
                        <td rel="noClickDetect"><input class="i-checks" type="checkbox" name="chksel"  title="" value="<?php echo  $cid ?>"></td>
                         
                        <td> 
                            <?php echo $row['first_name']?> <?php echo $row['last_name']?><br>

                            <?php
                            // Déterminer la couleur du badge selon le groupe
                            $color = 'secondary'; // default
                           switch ($row['schedule_group']) {
                            case 'A': 
                                $color = 'success'; 
                                break;    // vert

                            case 'B': 
                                $color = 'warning'; 
                                break;    // jaune

                            case 'C': 
                                $color = 'danger'; 
                                break;    // rouge

                            case 'D': 
                                $color = 'primary'; 
                                break;    // bleu (par exemple)
                        }
                            ?>

                            <span class="badge badge-secondary">M: <?php echo $row['id_number']?></span> &nbsp; 
                            <span class="badge badge-<?php echo $color ?>">Groupe <?php echo $row['schedule_group']?></span> &nbsp;
                            <span class="badge badge-secondary">Tél: <?php echo $row['phone_number']?></span><br>
                            <span class="badge">Email : <?php echo $row['email']?></span><br>
                        </td>

                          <td> 
                          <small>  <?php echo $row['last_logged_in']?> </small>    
                        </td>
                        
                         <td rel="noClickDetect">
                         <?php activation_status($row['active'],"active") ; ?>
                         </td> 
                         
                          <td> 
                          <span class="small text-secondary">
                              C: <?php echo ($row['created_on'])?>  <br> 
                              M: <?php echo ($row['updated_on'])?>  
                          </span>
                            </td>
                            <td rel="noClickDetect">
                                <a class="btn ico-edit"  data-toggle="tooltip" title=""  data-original-title="<?php echo MODIFY_TITLE?> "><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                              <?php if ( $allow_remove ) { ?>
                                <a class="btn ico-delete" data-toggle="tooltip" title=""  data-original-title="<?php echo REMOVE_TITLE?>"><i class="fa fa-trash-o" aria-hidden="true"></i></a> 
                             <?php  } ?>
                            </td>
                                    </tr>
                                   <!-- /tr -->  
                    </div>
         
    <?php
    }  
    ?>
    </tbody></table>

 
</div> <!-- .asset-inner -->


<div class="row">
                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                    <div class="result-paging-block">
                    <span> <?php echo PAGING_TITLE ?> <?php echo $pagination->current_page ?>  
                    <?php echo PAGING_SEPARATOR ?>  
                     <?php echo $pagination->total_pages ?>  
                        
                   - <?php echo $pagination->total_results;  ?>   <?php echo PAGING_RECORDS ?>   </span>
                    <?php //drop_down($rec_by_page,"bypage","10;20;30;50;100","10 ".BY_PAGE.";20 ".BY_PAGE.";30 ".BY_PAGE.";50 ".BY_PAGE.";100 ".BY_PAGE,"","",false,"selectfield")?>
                    </div>
                </div>

    
                <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                    <nav aria-label="grid navigation" class="paging-block">
                        <?php //echo $pagination->links_html;   ?> 
                    </nav>
                </div>
        </div>
    </div>



<?php } // end test $pagination->succes  ?>

       </form>

       </div> <!-- .content-wrap --> 
      </div> <!-- .col-lg-12 col-md-12 col-sm-12 col-12 -->  
	</div>  <!-- .row --> 
    </div> <!-- .container-fluid --> 



<!-- /=== CONTENT ZONE === -->  

<!-- === MODALS ZONE === -->  


<!-- /=== MODALS ZONE === === -->  

<?php } // end db_grid function ?>


<?php
require_once(__DIR__.'/ssinclude/partials/footer.php');

?>