<?php
// download.php
require_once(__DIR__ . '/ssinclude/app-init.php');    // ajuste le chemin si nécessaire
require_once(__DIR__ . '/ssinclude/app-session.php');

try {
    // Récupérer et valider le paramètre chiffré
    
    // --- Récupération du token chiffré dans l'URL ---
    // Exemple : download.php?FEEZEAEZEA  → $_SERVER['QUERY_STRING'] = 'FEEZEAEZEA'
    $encrypted_id = $_SERVER['QUERY_STRING'] ?? '';
    if (empty($encrypted_id)) {
        throw new Exception("Token manquant.");
    }

    $file_id = decrypt_data($encrypted_id);
     if (!is_numeric($file_id)) {
        throw new Exception("Format invalide.");
    }


    // Récupérer les informations du fichier en DB
    $stmt = $db->prepare("SELECT file_id, name, name_hashed, file_path, visibility FROM files WHERE file_id = ?");
    $stmt->execute([$file_id]);
    $file = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$file) {
        throw new Exception("Fichier introuvable.", 404);
    }

    // Construire le chemin physique du fichier sur le serveur
    // file_path doit être du type "medias/files/YYYY/MM/nom_haché.ext"
    // __DIR__ est supposé être adminfs/ si ce script est dans adminfs/
    $physicalPath = __DIR__ . '/../' . ltrim($file['file_path'], '/'); // ajuste si emplacement différent

    // Normalise les séparateurs
    $physicalPath = str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $physicalPath);

    if (!file_exists($physicalPath) || !is_file($physicalPath)) {
        throw new Exception("Fichier physiquement introuvable.", 404);
    }

    // Vérification d'accès si visibilité = private
    /*
    if ($file['visibility'] === 'private') {
        // Essayons d'identifier l'utilisateur connecté : adapte selon ta session
        $currentEmployeeId = $_SESSION['employee_id'] ?? $_SESSION['user_id'] ?? null;

        if (!$currentEmployeeId) {
            // Pas connecté => accès refusé
            throw new Exception("Accès refusé. Veuillez vous connecter.", 403);
        }

        // Vérifier que ce fichier est lié à cet employé
        $aclStmt = $db->prepare("
            SELECT ef.id_employee_files
            FROM employee_files ef
            JOIN files f ON f.file_id = ef.file_id
            WHERE ef.file_id = ? AND ef.employee_id = ?
            LIMIT 1
        ");
        $aclStmt->execute([$file_id, $currentEmployeeId]);
        $acl = $aclStmt->fetchColumn();

        if (!$acl) {
            throw new Exception("Accès refusé : vous n'êtes pas autorisé à télécharger ce fichier.", 403);
        }
    } */

    // Préparer headers et forcer le téléchargement avec le nom d'origine
    // Détecter le mime type de façon robuste
    if (function_exists('finfo_open')) {
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mimeType = finfo_file($finfo, $physicalPath);
        finfo_close($finfo);
    } else {
        $mimeType = mime_content_type($physicalPath) ?: 'application/octet-stream';
    }

    // Nettoyer le nom d'origine pour l'envoyer en header (protection basique)
    $downloadName = basename($file['name']);
    // Si besoin, on peut forcer l'encodage pour les navigateurs :
    $downloadNameHeader = rawurlencode($downloadName);

    // Headers pour forcer le téléchargement
    header('Pragma: public');
    header('Expires: 0');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Cache-Control: private', false);
    header('Content-Description: File Transfer');
    header('Content-Type: ' . $mimeType);
    // Content-Disposition: gérer les noms avec caractères spéciaux (double header pour compatibilité)
    header('Content-Disposition: attachment; filename="' . $downloadName . '"; filename*=UTF-8\'\'' . $downloadNameHeader);
    header('Content-Transfer-Encoding: binary');
    header('Content-Length: ' . filesize($physicalPath));

    // Envoyer le fichier de façon efficace (support gros fichiers)
    // Disable output buffering to decrease memory usage
    if (ob_get_level()) {
        ob_end_clean();
    }

    $handle = fopen($physicalPath, 'rb');
    if ($handle === false) {
        throw new Exception("Impossible d'ouvrir le fichier.", 500);
    }

    // Lecture & envoi par bloc (sécurisé pour gros fichiers)
    while (!feof($handle)) {
        echo fread($handle, 8192);
        flush();
        if (connection_aborted()) {
            break;
        }
    }
    fclose($handle);
    exit();

} catch (Exception $e) {
    // Retour simple : adapte selon ton UI (JSON ou page HTML)
    $code = $e->getCode() ?: 500;
    http_response_code($code);
    // Si appel AJAX ou front, tu peux renvoyer JSON ; sinon simple message.
    header('Content-Type: text/plain; charset=utf-8');
    echo "Erreur: " . $e->getMessage();
    exit();
}
