/*----------------------------
	  Front  - OnLoad  Loader + Custom Form Validation API
	------------------------------ */
window.addEventListener("load", function load(event){
	"use strict";
	window.removeEventListener("load", load, false); //remove listener, no longer needed
	$(".loader-overlay").fadeOut();
    // Attach Global Forms Validation API 
	var forms = document.getElementsByClassName('needs-validation');
	// Loop over them and prevent submission
	var validation = Array.prototype.filter.call(forms, function(form) {
		form.addEventListener('submit', function(event) {
			if (form.checkValidity() === false) {
				event.preventDefault();
				event.stopPropagation();
			}
			form.classList.add('was-validated');
		}, false);
	});
	notifications_detector()
}, false);
/*----------------------------
	 jQuery - OnReady 
------------------------------ */
(function ($) {
 "use strict";
	/*----------------------------
	 jQuery MeanMenu
	------------------------------ */
	if($('nav#dropdown').length){
		$('nav#dropdown').meanmenu();	
	}
	// render advanced select sytem  
	if($('.advancedselect').length){
	  $('.advancedselect').selectpicker(
		{
			noneSelectedText :	"Aucune sélection effectuée",
			noneResultsText : "Aucun résultat ne correspond {0}",
			style : "btn-select"
	   }
	  );
     }
	// left menu 
	if($('#menu1').length){
	  $('#menu1').metisMenu();
	}
   // custom checkboxes/radios 
	$('.i-checks').iCheck({
		checkboxClass: 'icheckbox_square-green',
		radioClass: 'iradio_square-green',
		inheritID: true,
		inheritClass: true,
	});
   // flatpickr date selector
   flatpickr(".flatpickr", {
	   allowInput: true,
		wrap: true,
		"locale": 'fr'
	 });
	$('[data-toggle="tooltip"]').tooltip(); 
	$('#sidebarCollapse').on('click', function () {
		 $('#sidebar').toggleClass('active');
	 });
	// Collapse ibox function
	$('#sidebar ul li').on('click', function () {
		var button = $(this).find('i.fa.indicator-mn');
		button.toggleClass('fa-plus').toggleClass('fa-minus');
	});
	/*-----------------------------
		Menu Stick
	---------------------------------*/
	if($('.sicker-menu').length){
		$(".sicker-menu").sticky({topSpacing:0});
	}
	$('#sidebarCollapse').on('click', function () {
		$("body").toggleClass("mini-navbar");
		SmoothlyMenu();
	});
	$(document).on('click', '.header-right-menu .dropdown-menu', function (e) {
		  e.stopPropagation();
	});
	/*----------------------------
	 wow js active
	------------------------------ */
	 // new WOW().init();
	/*----------------------------
	 owl active
	------------------------------ */  
	if($('#owl-demo').length){
	$("#owl-demo").owlCarousel({
      autoPlay: false, 
	  slideSpeed:2000,
	  pagination:false,
	  navigation:true,	  
      items : 4,
	 // transitionStyle : "fade",   [This code for animation ]  
	  navigationText:["<i class='fa fa-angle-left'></i>","<i class='fa fa-angle-right'></i>"],
      itemsDesktop : [1199,4],
	  itemsDesktopSmall : [980,3],
	  itemsTablet: [768,2],
	  itemsMobile : [479,1],
	}); 
}
	/*----------------------------
	 price-slider active
	------------------------------ */ 
	if($('#slider-range').length){ 
	  $( "#slider-range" ).slider({
	   range: true,
	   min: 40,
	   max: 600,
	   values: [ 60, 570 ],
	   slide: function( event, ui ) {
		$( "#amount" ).val( "£" + ui.values[ 0 ] + " - £" + ui.values[ 1 ] );
	   }
	  });
	  $( "#amount" ).val( "£" + $( "#slider-range" ).slider( "values", 0 ) +
		 " - £" + $( "#slider-range" ).slider( "values", 1 ) );
	}
	/*--------------------------
	 scrollUp
	---------------------------- */	
	/*
	$.scrollUp({
        scrollText: '<i class="fa fa-angle-up"></i>',
        easingType: 'linear',
        scrollSpeed: 900,
        animation: 'fade'
    }); 	   
 */
})(jQuery); 
/*--------------------------
	  function  : Notification listener 
	---------------------------- */	
	function notifications_detector() {	 	
		if($('.notify-alert').length){ 
			$('.notify-alert' ).each(function() {
				message = $( this ).text() 
				notify_alert(message)
			});
		}
		 if($('.notify-info').length){ 
				$('.notify-info' ).each(function() {
					message = $( this ).text() 
					notify_info(message)
				});
			}
    	if($('.notify-warning').length){ 
				$('.notify-warning' ).each(function() {
					message = $( this ).text() 
					notify_warning(message)
				});
			}
    	if($('.notify-success').length){ 
				$('.notify-success' ).each(function() {
					message = $( this ).text() 
					notify_success(message)
				});
			}
	}
/*--------------------------
	  function  : Notification call  
	---------------------------- */	
function notify_alert (message) { 
	 Lobibox.notify('error', {
	 soundPath: 'assets/sounds/' ,
	 iconSource: 'fontAwesome', 
	 position: 'top right',
	 title : 'Erreur',
	 msg: message  
	});
}
function notify_success (message) { 
		Lobibox.notify('success', {
		soundPath: 'assets/sounds/' ,
		iconSource: 'fontAwesome', 
		position: 'top right',
		title : 'Succès',
		msg: message  
	   });
   }
function notify_info (message) { 
	Lobibox.notify('info', {
	soundPath: 'assets/sounds/' ,
	iconSource: 'fontAwesome', 
	position: 'top right',
	title : 'Information',
	msg: message  
	 });
}
function notify_warning (message) { 
	Lobibox.notify('warning', {
	soundPath: 'assets/sounds/' ,
	iconSource: 'fontAwesome', 
	position: 'top right',
	title : 'Attention',
	msg: message  
   });
}
/*--------------------------
	  function  : confirm call  
	---------------------------- */	
function box_confirm (message,callbackfn) { 
    var lobibox = Lobibox.confirm({
	soundPath: 'assets/sounds/' ,
	iconSource: 'fontAwesome', 
	title : 'Confirmation',
	buttons: {
		yes: {
			'class': 'btn btn-danger',
			text: 'Confirmer',
			closeOnClick: true
		},
		no: {
			'class': 'btn btn-primary',
			text: 'Annuler',
			closeOnClick: true
		}
   },
   msg : message ,
   callback: function ($this, type, ev) {
		if (type=='yes')   
		{ 
			// execute call back 
			callbackfn()  
		}
    }
   });
}
/*--------------------------
	  function  :animate.css helper 
	---------------------------- */	
	function animateCSS(element, animationName, callback) {
		const node = document.querySelector(element)
		node.classList.add('animated', animationName)
		function handleAnimationEnd() {
			node.classList.remove('animated', animationName)
			node.removeEventListener('animationend', handleAnimationEnd)
			if (typeof callback === 'function') callback()
		}
		node.addEventListener('animationend', handleAnimationEnd)
	}
/*--------------------------
	  function  : add JSONfind helper 
	---------------------------- */	
function getObjects(obj, key, val) {
		var objects = [];
		for (var i in obj) {
			if (!obj.hasOwnProperty(i)) continue;
			if (typeof obj[i] == 'object') {
				objects = objects.concat(getObjects(obj[i], key, val));
			} else if (i == key && obj[key] == val) {
				objects.push(obj);
			}
		}
		return objects;
	}