<?php
require_once(__DIR__.'/../ssinclude/app-init.php');
require_once(__DIR__.'/../ssinclude/app-session.php');
header('Content-Type: application/json');

try {
    $file_id = $_POST['file_id'] ?? 0;
    if (!$file_id) throw new Exception("ID fichier manquant");

    // Récupérer le chemin du fichier
    $stmt = $db->prepare("SELECT file_path FROM files WHERE file_id = ?");
    $stmt->execute([$file_id]);
    $file = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$file) throw new Exception("Fichier introuvable");

    // Supprimer le fichier physiquement
    $filePath = __DIR__ . '/../../' . $file['file_path'];
    //echo $filePath;
    //exit;

    if (file_exists($filePath)) unlink($filePath);

    // Supprimer en base
    $stmt = $db->prepare("DELETE FROM files WHERE file_id = ?");
    $stmt->execute([$file_id]);

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
